from datetime import datetime
from typing import Optional
from pydantic import BaseModel

class SubscriptionCreate(BaseModel):
    name: str
    description: str
    price: float
    duration_days: int
    max_profile_views: int
    is_trial: bool = False  # ✅ Include this


class SubscriptionOut(SubscriptionCreate):
    id: int

    class Config:
        orm_mode = True



class RecruiterSubscriptionCreate(BaseModel):
    recruiter_id: int
    subscription_id: int

class RecruiterSubscriptionOut(BaseModel):
    id: int
    recruiter_id: int
    subscription_id: int
    start_date: datetime
    end_date: datetime
    is_active: bool

    class Config:
        orm_mode = True