from sqlalchemy import Column, Float, Integer, String, Text, ForeignKey, Enum
from database import Base
import enum

class ServiceCategory(enum.Enum):
    WEB_DEVELOPMENT = "Web Development"
    IT_SOFTWARE = "IT & Software"

class ServiceStatus(enum.Enum):
    ACTIVE = "active"
    INACTIVE = "inactive"
    PENDING = "pending"

class Service(Base):
    __tablename__ = "services"
    id = Column(Integer, primary_key=True, index=True)
    recruiter_id = Column(Integer)
    company_logo = Column(String(100), nullable=True)
    company_name = Column(String(100))
    company_rating = Column(Float, nullable=True)
    job_title = Column(String(100))
    job_location = Column(String(100))
    salary_inr = Column(String(100), nullable=True)
    salary_usd = Column(String(100), nullable=True)
    job_type = Column(String(100), nullable=True)
    job_description = Column(Text)
    responsibilities = Column(Text, nullable=True)  # Store as JSON/text if not using ARRAY
    requirements = Column(Text, nullable=True)
    tech_stack = Column(Text, nullable=True)
    benefits = Column(Text, nullable=True)
    apply_link = Column(String(100), nullable=True)
    service_category = Column(Enum(ServiceCategory), nullable=True)
    status = Column(Enum(ServiceStatus), default=ServiceStatus.ACTIVE)
    created_at = Column(String(100), nullable=False)  # Store as ISO format String(100)
    updated_at = Column(String(100), nullable=True)  # Store as ISO format String(100)
