from sqlalchemy import Column, Integer, String, Boolean, Text
from sqlalchemy.orm import relationship
from database import Base

# -------------------- Main User Table --------------------
class User(Base):
    __tablename__ = "users"  # consistent name across foreign keys

    id = Column(Integer, primary_key=True, index=True)
    name = Column(String(100), nullable=False)
    email = Column(String(100), unique=True, index=True, nullable=False)
    role = Column(String(100), nullable=False)  # admin, recruiter, user
    verified = Column(Boolean, default=False)  # Only verified recruiters are usable
    profile_completed = Column(Boolean, default=False)
    google_id = Column(String(100), unique=True, index=True, nullable=True)
    picture = Column(Text, nullable=True)

    # Relationships to profiles
    recruiter_profile = relationship("RecruiterProfile", backref="users", uselist=False)
    student_profile = relationship("StudentProfile", backref="users", uselist=False)
    admin_profile = relationship("AdminProfile", backref="users", uselist=False)
