# models/job_application_model.py

from sqlalchemy import Column, Integer, DateTime, String, UniqueConstraint
from database import Base

class JobApplication(Base):
    __tablename__ = "job_applications"
    id = Column(Integer, primary_key=True, index=True)
    user_id = Column(Integer, nullable=False)
    service_id = Column(Integer, nullable=False)
    applied_at = Column(DateTime, nullable=False)
    cv_path = Column(String, nullable=True)
    video_path = Column(String, nullable=True)

    __table_args__ = (UniqueConstraint('user_id', 'service_id', name='_user_service_uc'),)
